/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.converter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public final class RsaKeyConverters {
    private static final String DASHES = "-----";
    private static final String PKCS8_PEM_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PKCS8_PEM_FOOTER = "-----END PRIVATE KEY-----";
    private static final String X509_PEM_HEADER = "-----BEGIN PUBLIC KEY-----";
    private static final String X509_PEM_FOOTER = "-----END PUBLIC KEY-----";

    private RsaKeyConverters() {
    }

    public static Converter<InputStream, RSAPrivateKey> pkcs8() {
        KeyFactory keyFactory = RsaKeyConverters.rsaFactory();
        return source -> {
            List<String> lines = RsaKeyConverters.readAllLines(source);
            Assert.isTrue((!lines.isEmpty() && lines.get(0).startsWith(PKCS8_PEM_HEADER) ? 1 : 0) != 0, (String)"Key is not in PEM-encoded PKCS#8 format, please check that the header begins with ----------BEGIN PRIVATE KEY----------");
            StringBuilder base64Encoded = new StringBuilder();
            for (String line : lines) {
                if (!RsaKeyConverters.isNotPkcs8Wrapper(line)) continue;
                base64Encoded.append(line);
            }
            byte[] pkcs8 = Base64.getDecoder().decode(base64Encoded.toString());
            try {
                return (RSAPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pkcs8));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        };
    }

    public static Converter<InputStream, RSAPublicKey> x509() {
        KeyFactory keyFactory = RsaKeyConverters.rsaFactory();
        return source -> {
            List<String> lines = RsaKeyConverters.readAllLines(source);
            Assert.isTrue((!lines.isEmpty() && lines.get(0).startsWith(X509_PEM_HEADER) ? 1 : 0) != 0, (String)"Key is not in PEM-encoded X.509 format, please check that the header begins with ----------BEGIN PUBLIC KEY----------");
            StringBuilder base64Encoded = new StringBuilder();
            for (String line : lines) {
                if (!RsaKeyConverters.isNotX509Wrapper(line)) continue;
                base64Encoded.append(line);
            }
            byte[] x509 = Base64.getDecoder().decode(base64Encoded.toString());
            try {
                return (RSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(x509));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        };
    }

    private static List<String> readAllLines(InputStream source) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(source));
        return reader.lines().collect(Collectors.toList());
    }

    private static KeyFactory rsaFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static boolean isNotPkcs8Wrapper(String line) {
        return !PKCS8_PEM_HEADER.equals(line) && !PKCS8_PEM_FOOTER.equals(line);
    }

    private static boolean isNotX509Wrapper(String line) {
        return !X509_PEM_HEADER.equals(line) && !X509_PEM_FOOTER.equals(line);
    }
}

