/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonParser;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AwsRequestSignature;
import com.google.auth.oauth2.AwsRequestSigner;
import com.google.auth.oauth2.AwsSecurityCredentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class AwsCredentials
extends ExternalAccountCredentials {
    private final AwsCredentialSource awsCredentialSource;

    AwsCredentials(HttpTransportFactory transportFactory, String audience, String subjectTokenType, String tokenUrl, AwsCredentialSource credentialSource, @Nullable String tokenInfoUrl, @Nullable String serviceAccountImpersonationUrl, @Nullable String quotaProjectId, @Nullable String clientId, @Nullable String clientSecret, @Nullable Collection<String> scopes) {
        super(transportFactory, audience, subjectTokenType, tokenUrl, credentialSource, tokenInfoUrl, serviceAccountImpersonationUrl, quotaProjectId, clientId, clientSecret, scopes);
        this.awsCredentialSource = credentialSource;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(this.retrieveSubjectToken(), this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        String region = this.getAwsRegion();
        AwsSecurityCredentials credentials = this.getAwsSecurityCredentials();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-goog-cloud-target-resource", this.getAudience());
        AwsRequestSigner signer = AwsRequestSigner.newBuilder(credentials, "POST", this.awsCredentialSource.regionalCredentialVerificationUrl.replace("{region}", region), region).setAdditionalHeaders(headers).build();
        AwsRequestSignature awsRequestSignature = signer.sign();
        return this.buildSubjectToken(awsRequestSignature);
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return new AwsCredentials(this.transportFactory, this.getAudience(), this.getSubjectTokenType(), this.getTokenUrl(), this.awsCredentialSource, this.getTokenInfoUrl(), this.getServiceAccountImpersonationUrl(), this.getQuotaProjectId(), this.getClientId(), this.getClientSecret(), newScopes);
    }

    private String retrieveResource(String url, String resourceName) throws IOException {
        try {
            HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
            HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
            HttpResponse response = request.execute();
            return response.parseAsString();
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to retrieve AWS %s.", resourceName), e);
        }
    }

    private String buildSubjectToken(AwsRequestSignature signature) throws UnsupportedEncodingException {
        Map<String, String> canonicalHeaders = signature.getCanonicalHeaders();
        ArrayList<GenericJson> headerList = new ArrayList<GenericJson>();
        for (String headerName : canonicalHeaders.keySet()) {
            headerList.add(AwsCredentials.formatTokenHeaderForSts(headerName, canonicalHeaders.get(headerName)));
        }
        headerList.add(AwsCredentials.formatTokenHeaderForSts("Authorization", signature.getAuthorizationHeader()));
        headerList.add(AwsCredentials.formatTokenHeaderForSts("x-goog-cloud-target-resource", this.getAudience()));
        GenericJson token = new GenericJson();
        token.setFactory(OAuth2Utils.JSON_FACTORY);
        token.put("headers", headerList);
        token.put("method", (Object)signature.getHttpMethod());
        token.put("url", (Object)this.awsCredentialSource.regionalCredentialVerificationUrl.replace("{region}", signature.getRegion()));
        return URLEncoder.encode(token.toString(), "UTF-8");
    }

    private String getAwsRegion() throws IOException {
        String region = this.getEnv("AWS_REGION");
        if (region != null) {
            return region;
        }
        if (this.awsCredentialSource.regionUrl == null || this.awsCredentialSource.regionUrl.isEmpty()) {
            throw new IOException("Unable to determine the AWS region. The credential source does not contain the region URL.");
        }
        region = this.retrieveResource(this.awsCredentialSource.regionUrl, "region");
        return region.substring(0, region.length() - 1);
    }

    @VisibleForTesting
    AwsSecurityCredentials getAwsSecurityCredentials() throws IOException {
        String accessKeyId = this.getEnv("AWS_ACCESS_KEY_ID");
        String secretAccessKey = this.getEnv("AWS_SECRET_ACCESS_KEY");
        String token = this.getEnv("Token");
        if (accessKeyId != null && secretAccessKey != null) {
            return new AwsSecurityCredentials(accessKeyId, secretAccessKey, token);
        }
        if (this.awsCredentialSource.url == null || this.awsCredentialSource.url.isEmpty()) {
            throw new IOException("Unable to determine the AWS IAM role name. The credential source does not contain the url field.");
        }
        String roleName = this.retrieveResource(this.awsCredentialSource.url, "IAM role");
        String awsCredentials = this.retrieveResource(this.awsCredentialSource.url + "/" + roleName, "credentials");
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(awsCredentials);
        GenericJson genericJson = (GenericJson)parser.parseAndClose(GenericJson.class);
        accessKeyId = (String)genericJson.get((Object)"AccessKeyId");
        secretAccessKey = (String)genericJson.get((Object)"SecretAccessKey");
        token = (String)genericJson.get((Object)"Token");
        return new AwsSecurityCredentials(accessKeyId, secretAccessKey, token);
    }

    @VisibleForTesting
    String getEnv(String name) {
        return System.getenv(name);
    }

    private static GenericJson formatTokenHeaderForSts(String key, String value) {
        GenericJson header = new GenericJson();
        header.setFactory(OAuth2Utils.JSON_FACTORY);
        header.put("key", (Object)key);
        header.put("value", (Object)value);
        return header;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(AwsCredentials awsCredentials) {
        return new Builder(awsCredentials);
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        Builder() {
        }

        Builder(AwsCredentials credentials) {
            super(credentials);
        }

        @Override
        public AwsCredentials build() {
            return new AwsCredentials(this.transportFactory, this.audience, this.subjectTokenType, this.tokenUrl, (AwsCredentialSource)this.credentialSource, this.tokenInfoUrl, this.serviceAccountImpersonationUrl, this.quotaProjectId, this.clientId, this.clientSecret, (Collection<String>)this.scopes);
        }
    }

    static class AwsCredentialSource
    extends ExternalAccountCredentials.CredentialSource {
        private final String regionUrl;
        private final String url;
        private final String regionalCredentialVerificationUrl;

        AwsCredentialSource(Map<String, Object> credentialSourceMap) {
            super(credentialSourceMap);
            if (!credentialSourceMap.containsKey("regional_cred_verification_url")) {
                throw new IllegalArgumentException("A regional_cred_verification_url representing the GetCallerIdentity action URL must be specified.");
            }
            String environmentId = (String)credentialSourceMap.get("environment_id");
            Matcher matcher = Pattern.compile("(aws)([\\d]+)").matcher(environmentId);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid AWS environment ID.");
            }
            int environmentVersion = Integer.parseInt(matcher.group(2));
            if (environmentVersion != 1) {
                throw new IllegalArgumentException(String.format("AWS version %s is not supported in the current build.", environmentVersion));
            }
            this.regionUrl = (String)credentialSourceMap.get("region_url");
            this.url = (String)credentialSourceMap.get("url");
            this.regionalCredentialVerificationUrl = (String)credentialSourceMap.get("regional_cred_verification_url");
        }
    }
}

