/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp.credentials;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.io.CharSource;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

class ServiceAccountJsonGcpCredentialFactory
extends GcpCredentialFactory {
    private final String jsonContent;

    ServiceAccountJsonGcpCredentialFactory(String jsonContent) {
        this.jsonContent = jsonContent;
    }

    @Override
    protected ProjectCredentials doCreate() {
        try {
            ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)CharSource.wrap((CharSequence)this.jsonContent).asByteSource(StandardCharsets.UTF_8).openStream());
            return new ProjectCredentials((Credentials)serviceAccountCredentials, serviceAccountCredentials.getProjectId(), serviceAccountCredentials.getClientEmail());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot use credentials from " + this.jsonContent, e);
        }
    }

    @Override
    public String info() {
        return "credentials JSON content " + this.jsonContent;
    }
}

