/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.IllegalUriException$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Upgrade;
import akka.parboiled2.CharUtils$;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HttpRequest$ {
    public static final HttpRequest$ MODULE$ = new HttpRequest$();

    public Uri effectiveUri(Uri uri, Seq<HttpHeader> headers2, boolean securedConnection, Host defaultHostHeader) {
        Uri uri2;
        Tuple2 tuple2 = this.findHostAndWsUpgrade$1(headers2.iterator(), HttpRequest$.findHostAndWsUpgrade$default$2$1(), HttpRequest$.findHostAndWsUpgrade$default$3$1());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Host hostHeader = (Host)((OptionVal)tuple2._1()).x();
        boolean isWebsocket = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)new OptionVal((Object)hostHeader), (Object)BoxesRunTime.boxToBoolean((boolean)isWebsocket));
        Tuple2 tuple23 = tuple22;
        Host hostHeader2 = (Host)((OptionVal)tuple23._1()).x();
        boolean isWebsocket2 = tuple23._2$mcZ$sp();
        if (uri.isRelative()) {
            Host host;
            Host x;
            Host host2;
            Host host3;
            Host host4 = hostHeader2;
            OptionVal$.MODULE$.None();
            Host host5 = host4;
            if (!(null != null ? !((Object)null).equals(host5) : host5 != null)) {
                if (defaultHostHeader.isEmpty()) {
                    throw HttpRequest$.fail$1("is missing a `Host` header", uri);
                }
                host3 = defaultHostHeader;
            } else if (new OptionVal((Object)host4) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(host2 = (Host)OptionVal.Some$.MODULE$.unapply((Object)host4))) && (x = (Host)OptionVal$.MODULE$.get$extension((Object)host2)).isEmpty()) {
                if (defaultHostHeader.isEmpty()) {
                    throw HttpRequest$.fail$1("an empty `Host` header", uri);
                }
                host3 = defaultHostHeader;
            } else if (new OptionVal((Object)host4) != null && !OptionVal$.MODULE$.isEmpty$extension((Object)(host = (Host)OptionVal.Some$.MODULE$.unapply((Object)host4)))) {
                Host x2;
                host3 = x2 = (Host)OptionVal$.MODULE$.get$extension((Object)host);
            } else {
                throw new MatchError((Object)new OptionVal((Object)host4));
            }
            Host host6 = host3;
            if (host6 == null) {
                throw new MatchError((Object)host6);
            }
            Uri.Host hostHeaderHost = host6.host();
            int hostHeaderPort = host6.port();
            Tuple2 tuple24 = new Tuple2((Object)hostHeaderHost, (Object)BoxesRunTime.boxToInteger((int)hostHeaderPort));
            Tuple2 tuple25 = tuple24;
            Uri.Host hostHeaderHost2 = (Uri.Host)tuple25._1();
            int hostHeaderPort2 = tuple25._2$mcI$sp();
            String defaultScheme = isWebsocket2 ? Uri$.MODULE$.websocketScheme(securedConnection) : Uri$.MODULE$.httpScheme(securedConnection);
            uri2 = uri.toEffectiveRequestUri(hostHeaderHost2, hostHeaderPort2, defaultScheme, uri.toEffectiveRequestUri$default$4());
        } else if (OptionVal$.MODULE$.isEmpty$extension((Object)hostHeader2) || uri.authority().isEmpty() && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).isEmpty() || ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).host().equalsIgnoreCase(uri.authority().host()) && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).port() == uri.authority().port()) {
            uri2 = uri;
        } else {
            throw IllegalUriException$.MODULE$.apply(new StringBuilder(75).append("'Host' header value of request to `").append(uri).append("` doesn't match request target authority").toString(), new StringBuilder(40).append("Host header: ").append(new OptionVal((Object)hostHeader2)).append("\nrequest target authority: ").append(uri.authority()).toString());
        }
        return uri2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyUri(Uri uri) {
        if (uri.isEmpty()) {
            throw IllegalUriException$.MODULE$.apply("`uri` must not be empty", IllegalUriException$.MODULE$.apply$default$2());
        }
        int n = uri.scheme().length();
        switch (n) {
            case 0: {
                return;
            }
            case 4: {
                if (HttpRequest$.c$1(0, uri) != 'h' || HttpRequest$.c$1(1, uri) != 't' || HttpRequest$.c$1(2, uri) != 't' || HttpRequest$.c$1(3, uri) != 'p') throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", IllegalUriException$.MODULE$.apply$default$2());
                return;
            }
            case 5: {
                if (HttpRequest$.c$1(0, uri) != 'h' || HttpRequest$.c$1(1, uri) != 't' || HttpRequest$.c$1(2, uri) != 't' || HttpRequest$.c$1(3, uri) != 'p' || HttpRequest$.c$1(4, uri) != 's') throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", IllegalUriException$.MODULE$.apply$default$2());
                return;
            }
            case 2: {
                if (HttpRequest$.c$1(0, uri) != 'w' || HttpRequest$.c$1(1, uri) != 's') throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", IllegalUriException$.MODULE$.apply$default$2());
                return;
            }
            case 3: {
                if (HttpRequest$.c$1(0, uri) == 'w' && HttpRequest$.c$1(1, uri) == 's' && HttpRequest$.c$1(2, uri) == 's') return;
            }
            default: {
                throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", IllegalUriException$.MODULE$.apply$default$2());
            }
        }
    }

    public HttpRequest apply(HttpMethod method, Uri uri, Seq<HttpHeader> headers2, RequestEntity entity, HttpProtocol protocol) {
        return new HttpRequest(method, uri, headers2, Predef$.MODULE$.Map().empty(), entity, protocol);
    }

    public HttpMethod apply$default$1() {
        return HttpMethods$.MODULE$.GET();
    }

    public Uri apply$default$2() {
        return Uri$.MODULE$.$div();
    }

    public Seq<HttpHeader> apply$default$3() {
        return package$.MODULE$.Nil();
    }

    public RequestEntity apply$default$4() {
        return HttpEntity$.MODULE$.Empty();
    }

    public HttpProtocol apply$default$5() {
        return HttpProtocols$.MODULE$.HTTP$div1$u002E1();
    }

    public HttpRequest unapply(HttpRequest any) {
        return any;
    }

    private final Tuple2 findHostAndWsUpgrade$1(Iterator it, Host host, Option wsUpgrade) {
        while (!(OptionVal$.MODULE$.isDefined$extension((Object)host) && wsUpgrade.isDefined() || !it.hasNext())) {
            HttpHeader httpHeader = (HttpHeader)it.next();
            if (httpHeader instanceof Host) {
                Host host2 = (Host)httpHeader;
                host = (Host)OptionVal.Some$.MODULE$.apply((Object)host2);
                continue;
            }
            if (!(httpHeader instanceof Upgrade)) continue;
            Upgrade upgrade = (Upgrade)httpHeader;
            wsUpgrade = new Some((Object)BoxesRunTime.boxToBoolean((boolean)upgrade.hasWebSocket()));
        }
        return new Tuple2((Object)new OptionVal((Object)host), (Object)BoxesRunTime.boxToBoolean((boolean)wsUpgrade.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
    }

    private static final Host findHostAndWsUpgrade$default$2$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final Option findHostAndWsUpgrade$default$3$1() {
        return None$.MODULE$;
    }

    private static final Nothing$ fail$1(String detail, Uri uri$1) {
        throw IllegalUriException$.MODULE$.apply(new StringBuilder(80).append("Cannot establish effective URI of request to `").append(uri$1).append("`, request has a relative URI and ").append(detail).toString(), "consider setting `akka.http.server.default-host-header`");
    }

    private static final char c$1(int i, Uri uri$2) {
        return CharUtils$.MODULE$.toLowerCase(uri$2.scheme().charAt(i));
    }

    private HttpRequest$() {
    }
}

