/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.security.AccessController;
import java.util.ServiceLoader;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.DefaultConfiguration;

public interface ConfigurationFactory {
    public static ConfigurationFactory getInstance() {
        if (System.getSecurityManager() == null) {
            ServiceLoader<ConfigurationFactory> loader = ServiceLoader.load(ConfigurationFactory.class);
            ConfigurationFactory current = null;
            for (ConfigurationFactory factory : loader) {
                if (current == null) {
                    current = factory;
                    continue;
                }
                if (factory.priority() >= current.priority()) continue;
                current = factory;
            }
            return current == null ? () -> Integer.MAX_VALUE : current;
        }
        return AccessController.doPrivileged(() -> {
            ServiceLoader<ConfigurationFactory> loader = ServiceLoader.load(ConfigurationFactory.class);
            ConfigurationFactory current = null;
            for (ConfigurationFactory factory : loader) {
                if (current == null) {
                    current = factory;
                    continue;
                }
                if (factory.priority() >= current.priority()) continue;
                current = factory;
            }
            return current == null ? () -> Integer.MAX_VALUE : current;
        });
    }

    default public Configuration getConfiguration() {
        return this.getConfiguration(null);
    }

    default public Configuration getConfiguration(ResteasyConfiguration config) {
        return new DefaultConfiguration(config);
    }

    public int priority();
}

