/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.DummyLicense;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.AbstractLicenseService;
import com.xebialabs.license.service.LicenseService;
import java.io.File;

public class RegistrationLicenseService
extends AbstractLicenseService
implements LicenseService {
    private final LicenseReader licenseReader = new LicenseReader();

    public RegistrationLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) throws LicenseParseException, LicenseViolationException {
        super(licensePath, product, repositoryMetadataService);
        this.license = this.readLicense(this.licenseFile);
        if (this.license.isDateExpired()) {
            this.logLicenseError(this.licenseFile);
        }
    }

    @Override
    protected License readLicense(File licenseFile) throws LicenseParseException, LicenseViolationException {
        String licenseFilePath = licenseFile.getAbsolutePath();
        if (!licenseFile.exists()) {
            return DummyLicense.create();
        }
        log.info("Reading license from file {}", (Object)licenseFilePath);
        License license = this.licenseReader.readLicense(licenseFile);
        log.info(license.toLicenseContent());
        if (license.isDateExpired()) {
            log.warn("*** License has expired.");
        }
        return license;
    }
}

