/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.config.client.ConfigClientHealthProperties;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class ConfigServerHealthIndicator
extends AbstractHealthIndicator {
    private ConfigClientHealthProperties properties;
    private ConfigurableEnvironment environment;
    private long lastAccess = 0L;
    private PropertySource<?> cached;

    public ConfigServerHealthIndicator(ConfigurableEnvironment environment, ConfigClientHealthProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) {
        PropertySource<?> propertySource = this.getPropertySource();
        builder.up();
        if (propertySource instanceof CompositePropertySource) {
            ArrayList<String> sources = new ArrayList<String>();
            for (PropertySource ps : ((CompositePropertySource)propertySource).getPropertySources()) {
                sources.add(ps.getName());
            }
            builder.withDetail("propertySources", sources);
        } else if (propertySource != null) {
            builder.withDetail("propertySources", (Object)propertySource.toString());
        } else {
            builder.unknown().withDetail("error", (Object)"no property sources located");
        }
    }

    private PropertySource<?> getPropertySource() {
        long accessTime = System.currentTimeMillis();
        if (this.isCacheStale(accessTime)) {
            this.lastAccess = accessTime;
            MutablePropertySources propertySources = this.environment.getPropertySources();
            this.cached = propertySources.get("configClient");
        }
        return this.cached;
    }

    private boolean isCacheStale(long accessTime) {
        if (this.cached == null) {
            return true;
        }
        return accessTime - this.lastAccess >= this.properties.getTimeToLive().toMillis();
    }
}

