/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.IOException;
import java.util.List;

public abstract class OverthereFileDirectoryWalker {
    public static final int ROOT = 0;
    private final int depthLimit;

    protected OverthereFileDirectoryWalker() {
        this(-1);
    }

    protected OverthereFileDirectoryWalker(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    protected final void walk(OverthereFile startDirectory) throws RuntimeIOException {
        try {
            if (startDirectory == null) {
                throw new NullPointerException("Start Directory is null");
            }
            this.handleStart(startDirectory);
            this.walk(startDirectory, 0);
            this.handleEnd();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void walk(OverthereFile directory, int depth) throws IOException {
        if (this.handleDirectory(directory, depth)) {
            this.handleDirectoryStart(directory, depth);
            int childDepth = depth + 1;
            if (this.depthLimit < 0 || childDepth <= this.depthLimit) {
                List<OverthereFile> childFiles = this.listFiles(directory);
                if (childFiles == null) {
                    this.handleRestricted(directory, childDepth);
                } else {
                    for (OverthereFile childFile : childFiles) {
                        if (childFile.isDirectory()) {
                            this.walk(childFile, childDepth);
                            continue;
                        }
                        this.handleFile(childFile, childDepth);
                    }
                }
            }
            this.handleDirectoryEnd(directory, depth);
        }
    }

    protected List<OverthereFile> listFiles(OverthereFile directory) {
        return directory.listFiles();
    }

    protected void handleStart(OverthereFile startDirectory) throws IOException {
    }

    protected boolean handleDirectory(OverthereFile directory, int depth) throws IOException {
        return true;
    }

    protected void handleDirectoryStart(OverthereFile directory, int depth) throws IOException {
    }

    protected void handleFile(OverthereFile file, int depth) throws IOException {
    }

    protected void handleRestricted(OverthereFile directory, int depth) throws IOException {
    }

    protected void handleDirectoryEnd(OverthereFile directory, int depth) throws IOException {
    }

    protected void handleEnd() throws IOException {
    }
}

