/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.query.qom;

import java.util.BitSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.And;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.BindVariableValue;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.ChildNode;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.ChildNodeJoinCondition;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Column;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Comparison;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Constraint;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.DescendantNode;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.DescendantNodeJoinCondition;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.DynamicOperand;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.EquiJoinCondition;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.FullTextSearch;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.FullTextSearchScore;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Join;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.JoinCondition;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Length;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Literal;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.LowerCase;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.NodeLocalName;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.NodeName;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Not;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Or;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Ordering;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.PropertyExistence;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.PropertyValue;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModel;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.SameNode;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.SameNodeJoinCondition;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Selector;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Source;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.StaticOperand;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.UpperCase;
import org.apache.jackrabbit.spi.commons.query.qom.AndImpl;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ComparisonImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ConstraintImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.EquiJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LengthImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LiteralImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NotImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SourceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.StaticOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.UpperCaseImpl;

public abstract class QueryObjectModelFactoryImpl
implements QueryObjectModelFactory {
    private static final BitSet VALID_OPERATORS = new BitSet();
    private static final BitSet VALID_JOIN_TYPES = new BitSet();
    private static final BitSet VALID_ORDERS = new BitSet();
    private final NamePathResolver resolver;

    public QueryObjectModelFactoryImpl(NamePathResolver resolver) {
        this.resolver = resolver;
    }

    protected abstract QueryObjectModel createQuery(QueryObjectModelTree var1) throws InvalidQueryException, RepositoryException;

    public QueryObjectModel createQuery(Selector selector, Constraint constraint, Ordering[] orderings, Column[] columns) throws InvalidQueryException, RepositoryException {
        return this.createQuery((Source)selector, constraint, orderings, columns);
    }

    public QueryObjectModel createQuery(Source source, Constraint constraint, Ordering[] orderings, Column[] columns) throws InvalidQueryException, RepositoryException {
        ColumnImpl[] cols;
        OrderingImpl[] ords;
        if (source == null) {
            throw new RepositoryException("source must not be null");
        }
        if (!(source instanceof SourceImpl)) {
            throw new RepositoryException("Unknown Source implementation");
        }
        if (constraint != null && !(constraint instanceof ConstraintImpl)) {
            throw new RepositoryException("Unknown Constraint implementation");
        }
        if (orderings != null) {
            ords = new OrderingImpl[orderings.length];
            for (int i = 0; i < orderings.length; ++i) {
                if (!(orderings[i] instanceof OrderingImpl)) {
                    throw new RepositoryException("Unknown Ordering implementation");
                }
                ords[i] = (OrderingImpl)orderings[i];
            }
        } else {
            ords = OrderingImpl.EMPTY_ARRAY;
        }
        if (columns != null) {
            cols = new ColumnImpl[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                if (!(columns[i] instanceof ColumnImpl)) {
                    throw new RepositoryException("Unknown Column implementation");
                }
                cols[i] = (ColumnImpl)columns[i];
            }
        } else {
            cols = ColumnImpl.EMPTY_ARRAY;
        }
        QueryObjectModelTree qomTree = new QueryObjectModelTree(this.resolver, (SourceImpl)source, (ConstraintImpl)constraint, ords, cols);
        return this.createQuery(qomTree);
    }

    public Selector selector(String nodeTypeName) throws InvalidQueryException, RepositoryException {
        Name ntName = this.checkNodeTypeName(nodeTypeName);
        return new SelectorImpl(this.resolver, ntName, ntName);
    }

    public Selector selector(String nodeTypeName, String selectorName) throws InvalidQueryException, RepositoryException {
        return new SelectorImpl(this.resolver, this.checkNodeTypeName(nodeTypeName), this.checkSelectorName(selectorName));
    }

    public Join join(Source left, Source right, int joinType, JoinCondition joinCondition) throws InvalidQueryException, RepositoryException {
        if (!(left instanceof SourceImpl) || !(right instanceof SourceImpl)) {
            throw new RepositoryException("Unknown Source implementation");
        }
        if (!(joinCondition instanceof JoinConditionImpl)) {
            throw new RepositoryException("Unknwon JoinCondition implementation");
        }
        if (!VALID_JOIN_TYPES.get(joinType)) {
            throw new RepositoryException("Invalid joinType");
        }
        return new JoinImpl(this.resolver, (SourceImpl)left, (SourceImpl)right, joinType, (JoinConditionImpl)joinCondition);
    }

    public EquiJoinCondition equiJoinCondition(String selector1Name, String property1Name, String selector2Name, String property2Name) throws InvalidQueryException, RepositoryException {
        return new EquiJoinConditionImpl(this.resolver, this.checkSelectorName(selector1Name), this.checkPropertyName(property1Name), this.checkSelectorName(selector2Name), this.checkPropertyName(property2Name));
    }

    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name) throws InvalidQueryException, RepositoryException {
        return new SameNodeJoinConditionImpl(this.resolver, this.checkSelectorName(selector1Name), this.checkSelectorName(selector2Name), null);
    }

    public SameNodeJoinCondition sameNodeJoinCondition(String selector1Name, String selector2Name, String selector2Path) throws InvalidQueryException, RepositoryException {
        return new SameNodeJoinConditionImpl(this.resolver, this.checkSelectorName(selector1Name), this.checkSelectorName(selector2Name), this.checkPath(selector2Path));
    }

    public ChildNodeJoinCondition childNodeJoinCondition(String childSelectorName, String parentSelectorName) throws InvalidQueryException, RepositoryException {
        return new ChildNodeJoinConditionImpl(this.resolver, this.checkSelectorName(childSelectorName), this.checkSelectorName(parentSelectorName));
    }

    public DescendantNodeJoinCondition descendantNodeJoinCondition(String descendantSelectorName, String ancestorSelectorName) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeJoinConditionImpl(this.resolver, this.checkSelectorName(descendantSelectorName), this.checkSelectorName(ancestorSelectorName));
    }

    public And and(Constraint constraint1, Constraint constraint2) throws InvalidQueryException, RepositoryException {
        if (constraint1 == null || constraint2 == null) {
            throw new RepositoryException("Constraints must not be null");
        }
        if (constraint1 instanceof ConstraintImpl && constraint2 instanceof ConstraintImpl) {
            return new AndImpl(this.resolver, (ConstraintImpl)constraint1, (ConstraintImpl)constraint2);
        }
        throw new RepositoryException("Unknown constraint implementation");
    }

    public Or or(Constraint constraint1, Constraint constraint2) throws InvalidQueryException, RepositoryException {
        if (constraint1 == null || constraint2 == null) {
            throw new RepositoryException("Constraints must not be null");
        }
        if (constraint1 instanceof ConstraintImpl && constraint2 instanceof ConstraintImpl) {
            return new OrImpl(this.resolver, (ConstraintImpl)constraint1, (ConstraintImpl)constraint2);
        }
        throw new RepositoryException("Unknown constraint implementation");
    }

    public Not not(Constraint constraint) throws InvalidQueryException, RepositoryException {
        if (!(constraint instanceof ConstraintImpl)) {
            throw new RepositoryException("Unknown Constraint implementation");
        }
        return new NotImpl(this.resolver, (ConstraintImpl)constraint);
    }

    public Comparison comparison(DynamicOperand operand1, int operator, StaticOperand operand2) throws InvalidQueryException, RepositoryException {
        if (operand1 == null || operand2 == null) {
            throw new RepositoryException("operands must not be null");
        }
        if (!VALID_OPERATORS.get(operator)) {
            throw new RepositoryException("invalid operator");
        }
        if (operand1 instanceof DynamicOperandImpl && operand2 instanceof StaticOperandImpl) {
            return new ComparisonImpl(this.resolver, (DynamicOperandImpl)operand1, operator, (StaticOperandImpl)operand2);
        }
        throw new RepositoryException("Unknown operand implementation");
    }

    public PropertyExistence propertyExistence(String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyExistenceImpl(this.resolver, null, this.checkPropertyName(propertyName));
    }

    public PropertyExistence propertyExistence(String selectorName, String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyExistenceImpl(this.resolver, this.checkSelectorName(selectorName), this.checkPropertyName(propertyName));
    }

    public FullTextSearch fullTextSearch(String propertyName, String fullTextSearchExpression) throws InvalidQueryException, RepositoryException {
        Name propName = null;
        if (propertyName != null) {
            propName = this.checkPropertyName(propertyName);
        }
        return new FullTextSearchImpl(this.resolver, null, propName, this.checkFullTextSearchExpression(fullTextSearchExpression));
    }

    public FullTextSearch fullTextSearch(String selectorName, String propertyName, String fullTextSearchExpression) throws InvalidQueryException, RepositoryException {
        Name propName = null;
        if (propertyName != null) {
            propName = this.checkPropertyName(propertyName);
        }
        return new FullTextSearchImpl(this.resolver, this.checkSelectorName(selectorName), propName, this.checkFullTextSearchExpression(fullTextSearchExpression));
    }

    public SameNode sameNode(String path) throws InvalidQueryException, RepositoryException {
        return new SameNodeImpl(this.resolver, null, this.checkPath(path));
    }

    public SameNode sameNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new SameNodeImpl(this.resolver, this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public ChildNode childNode(String path) throws InvalidQueryException, RepositoryException {
        return new ChildNodeImpl(this.resolver, null, this.checkPath(path));
    }

    public ChildNode childNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new ChildNodeImpl(this.resolver, this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public DescendantNode descendantNode(String path) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeImpl(this.resolver, null, this.checkPath(path));
    }

    public DescendantNode descendantNode(String selectorName, String path) throws InvalidQueryException, RepositoryException {
        return new DescendantNodeImpl(this.resolver, this.checkSelectorName(selectorName), this.checkPath(path));
    }

    public PropertyValue propertyValue(String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyValueImpl(this.resolver, null, this.checkPropertyName(propertyName));
    }

    public PropertyValue propertyValue(String selectorName, String propertyName) throws InvalidQueryException, RepositoryException {
        return new PropertyValueImpl(this.resolver, this.checkSelectorName(selectorName), this.checkPropertyName(propertyName));
    }

    public Length length(PropertyValue propertyValue) throws InvalidQueryException, RepositoryException {
        if (!(propertyValue instanceof PropertyValueImpl)) {
            throw new RepositoryException("Unknown PropertyValue implementation");
        }
        return new LengthImpl(this.resolver, (PropertyValueImpl)propertyValue);
    }

    public NodeName nodeName() throws InvalidQueryException, RepositoryException {
        return new NodeNameImpl(this.resolver, null);
    }

    public NodeName nodeName(String selectorName) throws InvalidQueryException, RepositoryException {
        return new NodeNameImpl(this.resolver, this.checkSelectorName(selectorName));
    }

    public NodeLocalName nodeLocalName() throws InvalidQueryException, RepositoryException {
        return new NodeLocalNameImpl(this.resolver, null);
    }

    public NodeLocalName nodeLocalName(String selectorName) throws InvalidQueryException, RepositoryException {
        return new NodeLocalNameImpl(this.resolver, this.checkSelectorName(selectorName));
    }

    public FullTextSearchScore fullTextSearchScore() throws InvalidQueryException, RepositoryException {
        return new FullTextSearchScoreImpl(this.resolver, null);
    }

    public FullTextSearchScore fullTextSearchScore(String selectorName) throws InvalidQueryException, RepositoryException {
        return new FullTextSearchScoreImpl(this.resolver, this.checkSelectorName(selectorName));
    }

    public LowerCase lowerCase(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new LowerCaseImpl(this.resolver, (DynamicOperandImpl)operand);
    }

    public UpperCase upperCase(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new UpperCaseImpl(this.resolver, (DynamicOperandImpl)operand);
    }

    public BindVariableValue bindVariable(String bindVariableName) throws InvalidQueryException, RepositoryException {
        if (bindVariableName == null) {
            throw new RepositoryException("bindVariableName must not be null");
        }
        try {
            return new BindVariableValueImpl(this.resolver, this.resolver.getQName(bindVariableName));
        }
        catch (NameException e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }

    public Literal literal(Value value) throws InvalidQueryException, RepositoryException {
        if (value == null) {
            throw new RepositoryException("value must not be null");
        }
        return new LiteralImpl(this.resolver, value);
    }

    public Ordering ascending(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new OrderingImpl(this.resolver, (DynamicOperandImpl)operand, 301);
    }

    public Ordering descending(DynamicOperand operand) throws InvalidQueryException, RepositoryException {
        if (!(operand instanceof DynamicOperandImpl)) {
            throw new RepositoryException("Unknown DynamicOperand implementation");
        }
        return new OrderingImpl(this.resolver, (DynamicOperandImpl)operand, 302);
    }

    public Column column(String propertyName) throws InvalidQueryException, RepositoryException {
        Name propName = null;
        if (propertyName != null) {
            try {
                propName = this.resolver.getQName(propertyName);
            }
            catch (NameException e) {
                throw new InvalidQueryException(e.getMessage());
            }
        }
        return new ColumnImpl(this.resolver, null, propName, propName);
    }

    public Column column(String propertyName, String columnName) throws InvalidQueryException, RepositoryException {
        if (propertyName == null && columnName != null) {
            throw new RepositoryException("columnName must be null if propertyName is null");
        }
        Name propName = null;
        if (propertyName != null) {
            try {
                propName = this.resolver.getQName(propertyName);
            }
            catch (NameException e) {
                throw new InvalidQueryException(e.getMessage());
            }
        }
        Name colName = null;
        if (columnName != null) {
            try {
                colName = this.resolver.getQName(columnName);
            }
            catch (NameException e) {
                throw new InvalidQueryException(e.getMessage());
            }
        }
        return new ColumnImpl(this.resolver, null, propName, colName);
    }

    public Column column(String selectorName, String propertyName, String columnName) throws InvalidQueryException, RepositoryException {
        if (propertyName == null && columnName != null) {
            throw new RepositoryException("columnName must be null if propertyName is null");
        }
        Name propName = null;
        if (propertyName != null) {
            try {
                propName = this.resolver.getQName(propertyName);
            }
            catch (NameException e) {
                throw new InvalidQueryException(e.getMessage());
            }
        }
        Name colName = null;
        if (columnName != null) {
            try {
                colName = this.resolver.getQName(columnName);
            }
            catch (NameException e) {
                throw new InvalidQueryException(e.getMessage());
            }
        }
        return new ColumnImpl(this.resolver, this.checkSelectorName(selectorName), propName, colName);
    }

    private Name checkSelectorName(String selectorName) throws RepositoryException {
        if (selectorName == null) {
            throw new RepositoryException("selectorName must not be null");
        }
        try {
            return this.resolver.getQName(selectorName);
        }
        catch (NameException e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }

    private Name checkNodeTypeName(String nodeTypeName) throws RepositoryException {
        if (nodeTypeName == null) {
            throw new RepositoryException("nodeTypeName must not be null");
        }
        try {
            return this.resolver.getQName(nodeTypeName);
        }
        catch (NameException e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }

    private Path checkPath(String path) throws RepositoryException {
        if (path == null) {
            throw new RepositoryException("path must not be null");
        }
        try {
            return this.resolver.getQPath(path);
        }
        catch (NameException e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }

    private Name checkPropertyName(String propertyName) throws RepositoryException {
        if (propertyName == null) {
            throw new RepositoryException("propertyName must not be null");
        }
        try {
            return this.resolver.getQName(propertyName);
        }
        catch (NameException e) {
            throw new InvalidQueryException(e.getMessage());
        }
    }

    private String checkFullTextSearchExpression(String fullTextSearchExpression) throws RepositoryException {
        if (fullTextSearchExpression == null) {
            throw new RepositoryException("fullTextSearchExpression must not be null");
        }
        return fullTextSearchExpression;
    }

    static {
        VALID_OPERATORS.set(201);
        VALID_OPERATORS.set(205);
        VALID_OPERATORS.set(206);
        VALID_OPERATORS.set(203);
        VALID_OPERATORS.set(204);
        VALID_OPERATORS.set(207);
        VALID_OPERATORS.set(202);
        VALID_JOIN_TYPES.set(101);
        VALID_JOIN_TYPES.set(102);
        VALID_JOIN_TYPES.set(103);
        VALID_ORDERS.set(301);
        VALID_ORDERS.set(302);
    }
}

