/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import javax.annotation.Nullable;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.FileBasedSshTransportConfigCallback;
import org.springframework.cloud.config.server.ssh.PropertiesBasedSshTransportConfigCallback;
import org.springframework.cloud.config.server.support.GoogleCloudSourceSupport;

public class TransportConfigCallbackFactory {
    @Nullable
    private final TransportConfigCallback customTransportConfigCallback;
    @Nullable
    private final GoogleCloudSourceSupport googleCloudSourceSupport;

    public TransportConfigCallbackFactory(TransportConfigCallback customTransportConfigCallback, GoogleCloudSourceSupport googleCloudSourceSupport) {
        this.customTransportConfigCallback = customTransportConfigCallback;
        this.googleCloudSourceSupport = googleCloudSourceSupport;
    }

    public TransportConfigCallback build(MultipleJGitEnvironmentProperties environmentProperties) {
        String uri;
        if (this.customTransportConfigCallback != null) {
            return this.customTransportConfigCallback;
        }
        if (this.googleCloudSourceSupport != null && this.googleCloudSourceSupport.canHandle(uri = environmentProperties.getUri())) {
            return this.googleCloudSourceSupport.createTransportConfigCallback();
        }
        return this.buildSshTransportConfigCallback(environmentProperties);
    }

    private TransportConfigCallback buildSshTransportConfigCallback(MultipleJGitEnvironmentProperties gitEnvironmentProperties) {
        if (gitEnvironmentProperties.isIgnoreLocalSshSettings()) {
            return new PropertiesBasedSshTransportConfigCallback(gitEnvironmentProperties);
        }
        return new FileBasedSshTransportConfigCallback(gitEnvironmentProperties);
    }
}

