/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.event.Logging$;
import akka.pattern.BackoffSupervisor$;
import akka.stream.Attributes;
import akka.stream.Attributes$LogLevels$;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.RestartSettings;
import akka.stream.Shape;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogicWithLogging;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd!\u0002\u000e\u001c\u0003\u0013\u0011\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003S\u0001\u0011\u00051\u000bC\u0004\\\u0001\u0001\u0007I\u0011\u0001/\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\"1q\r\u0001Q!\nuCq\u0001\u001b\u0001A\u0002\u0013\u0005\u0011\u000eC\u0004s\u0001\u0001\u0007I\u0011A:\t\rU\u0004\u0001\u0015)\u0003k\u0011\u001d1\b\u00011A\u0005\u0002]Dq\u0001\u001f\u0001A\u0002\u0013\u0005\u0011\u0010\u0003\u0004|\u0001\u0001\u0006Ka\u0014\u0005\u0006y\u0002!\t& \u0005\b\u0003'\u0001a\u0011CA\u000b\u0011\u001d\t9\u0002\u0001D\t\u0003+Aa!!\u0007\u0001\t\u00139\bbBA\u000e\u0001\u0011U\u0011Q\u0004\u0005\b\u0003{\u0001AQCA \u0011\u001d\t9\u0006\u0001C\u000b\u00033Bq!a\u0017\u0001\t+\t)\u0002C\u0004\u0002^\u0001!\t&a\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002\u0016\t9\"+Z:uCJ$x+\u001b;i\u0005\u0006\u001c7n\u001c4g\u0019><\u0017n\u0019\u0006\u00039u\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003=}\taa\u001d;sK\u0006l'\"\u0001\u0011\u0002\t\u0005\\7.Y\u0002\u0001+\t\u00193h\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\u0011q%H\u0001\u0006gR\fw-Z\u0005\u0003S\u0019\u0012q\u0004V5nKJ<%/\u00199i'R\fw-\u001a'pO&\u001cw+\u001b;i\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0011\u00051*dBA\u00174!\tq\u0013'D\u00010\u0015\t\u0001\u0014%\u0001\u0004=e>|GO\u0010\u0006\u0002e\u0005)1oY1mC&\u0011A'M\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025c\u0005)1\u000f[1qKB\u0011!h\u000f\u0007\u0001\t\u0015a\u0004A1\u0001>\u0005\u0005\u0019\u0016C\u0001 C!\ty\u0004)D\u00012\u0013\t\t\u0015GA\u0004O_RD\u0017N\\4\u0011\u0005\r#U\"A\u000f\n\u0005\u0015k\"!B*iCB,\u0017aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\bCA\"I\u0013\tIUD\u0001\u0006BiR\u0014\u0018NY;uKN\f\u0001b]3ui&twm\u001d\t\u0003\u00072K!!T\u000f\u0003\u001fI+7\u000f^1siN+G\u000f^5oON\fab\u001c8ms>sg)Y5mkJ,7\u000f\u0005\u0002@!&\u0011\u0011+\r\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q1AKV,Y3j\u00032!\u0016\u0001:\u001b\u0005Y\u0002\"\u0002\u0016\u0007\u0001\u0004Y\u0003\"\u0002\u001d\u0007\u0001\u0004I\u0004\"\u0002$\u0007\u0001\u00049\u0005\"\u0002&\u0007\u0001\u0004Y\u0005\"\u0002(\u0007\u0001\u0004y\u0015\u0001\u0004:fgR\f'\u000f^\"pk:$X#A/\u0011\u0005}r\u0016BA02\u0005\rIe\u000e^\u0001\u0011e\u0016\u001cH/\u0019:u\u0007>,h\u000e^0%KF$\"AY3\u0011\u0005}\u001a\u0017B\u000132\u0005\u0011)f.\u001b;\t\u000f\u0019D\u0011\u0011!a\u0001;\u0006\u0019\u0001\u0010J\u0019\u0002\u001bI,7\u000f^1si\u000e{WO\u001c;!\u00035\u0011Xm]3u\t\u0016\fG\r\\5oKV\t!\u000e\u0005\u0002la6\tAN\u0003\u0002n]\u0006AA-\u001e:bi&|gN\u0003\u0002pc\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Ed'\u0001\u0003#fC\u0012d\u0017N\\3\u0002#I,7/\u001a;EK\u0006$G.\u001b8f?\u0012*\u0017\u000f\u0006\u0002ci\"9amCA\u0001\u0002\u0004Q\u0017A\u0004:fg\u0016$H)Z1eY&tW\rI\u0001\nM&t\u0017n\u001d5j]\u001e,\u0012aT\u0001\u000eM&t\u0017n\u001d5j]\u001e|F%Z9\u0015\u0005\tT\bb\u00024\u000f\u0003\u0003\u0005\raT\u0001\u000bM&t\u0017n\u001d5j]\u001e\u0004\u0013!\u00037pON{WO]2f+\u0005q\bgA@\u0002\bA)A&!\u0001\u0002\u0006%\u0019\u00111A\u001c\u0003\u000b\rc\u0017m]:\u0011\u0007i\n9\u0001B\u0006\u0002\nA\t\t\u0011!A\u0003\u0002\u0005-!aA0%oE\u0019a(!\u0004\u0011\u0007}\ny!C\u0002\u0002\u0012E\u00121!\u00118z\u0003)\u0019H/\u0019:u\u000fJ\f\u0007\u000f\u001b\u000b\u0002E\u00069!-Y2l_\u001a4\u0017A\u00047pO\u001eLgnZ#oC\ndW\rZ\u0001\u000fGJ,\u0017\r^3Tk\nLe\u000e\\3u+\u0011\ty\"a\f\u0015\t\u0005\u0005\u00121\u0007\t\u0007\u0003G\t)#!\f\u000e\u0003\u0001IA!a\n\u0002*\ta1+\u001e2TS:\\\u0017J\u001c7fi&\u0019\u00111\u0006\u0014\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000e\u00042AOA\u0018\t\u001d\t\t\u0004\u0006b\u0001\u0003\u0017\u0011\u0011\u0001\u0016\u0005\b\u0003k!\u0002\u0019AA\u001c\u0003\ryW\u000f\u001e\t\u0006\u0007\u0006e\u0012QF\u0005\u0004\u0003wi\"AB(vi2,G/A\bde\u0016\fG/Z*vE>+H\u000f\\3u+\u0011\t\t%a\u0013\u0015\t\u0005\r\u0013Q\n\t\u0007\u0003G\t)%!\u0013\n\t\u0005\u001d\u0013\u0011\u0006\u0002\u0010'V\u00147k\\;sG\u0016|U\u000f\u001e7fiB\u0019!(a\u0013\u0005\u000f\u0005ERC1\u0001\u0002\f!9\u0011qJ\u000bA\u0002\u0005E\u0013AA5o!\u0015\u0019\u00151KA%\u0013\r\t)&\b\u0002\u0006\u0013:dW\r^\u0001\u0013[\u0006D(+Z:uCJ$8OU3bG\",G\rF\u0001P\u0003Q\u00198\r[3ek2,'+Z:uCJ$H+[7fe\u00069qN\u001c+j[\u0016\u0014Hc\u00012\u0002b!9\u00111\r\rA\u0002\u00055\u0011\u0001\u0003;j[\u0016\u00148*Z=\u0002\u0011A\u0014Xm\u0015;beR\u0004")
public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final Attributes inheritedAttributes;
    private final RestartSettings settings;
    public final boolean akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    @Override
    public Class<?> logSource() {
        return RestartWithBackoffLogic.class;
    }

    public abstract void startGraph();

    public abstract void backoff();

    public boolean akka$stream$scaladsl$RestartWithBackoffLogic$$loggingEnabled() {
        boolean bl;
        Option option = this.inheritedAttributes.get(ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
        if (option instanceof Some) {
            Some some = (Some)option;
            Attributes.LogLevels levels = (Attributes.LogLevels)some.value();
            bl = levels.onFailure() != Attributes$LogLevels$.MODULE$.Off();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        void var2_2;
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringBuilder(24).append("RestartWithBackoff").append(this.name).append(".subIn").toString());
        sinkIn.setHandler(new InHandler(this, out, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPush() {
                this.$outer.push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.complete(this.out$1);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached()) {
                    this.$outer.fail(this.out$1, ex);
                } else {
                    if (this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$loggingEnabled()) {
                        this.$outer.log().warning("Restarting graph due to failure. stack_trace: {}", (Object)Logging$.MODULE$.stackTraceFor(ex));
                    }
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.sinkIn$1 = sinkIn$1;
                InHandler.$init$(this);
            }
        });
        this.setHandler(out, new OutHandler(this, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                this.sinkIn$1.pull();
            }

            public void onDownstreamFinish(Throwable cause) {
                this.$outer.finishing_$eq(true);
                this.sinkIn$1.cancel(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sinkIn$1 = sinkIn$1;
                OutHandler.$init$(this);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in) {
        void var2_2;
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringBuilder(25).append("RestartWithBackoff").append(this.name).append(".subOut").toString());
        sourceOut.setHandler(new OutHandler(this, in, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                block1: {
                    block0: {
                        if (!this.$outer.isAvailable(this.in$1)) break block0;
                        this.sourceOut$1.push(this.$outer.grab(this.in$1));
                        break block1;
                    }
                    if (this.$outer.hasBeenPulled(this.in$1)) break block1;
                    this.$outer.pull(this.in$1);
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.cancel(this.in$1, cause);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = sourceOut$1;
                OutHandler.$init$(this);
            }
        });
        this.setHandler(in, new InHandler(this, sourceOut, in){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;
            private final Inlet in$1;

            public void onPush() {
                block0: {
                    if (!this.sourceOut$1.isAvailable()) break block0;
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.fail(ex);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceOut$1 = sourceOut$1;
                this.in$1 = in$1;
                InHandler.$init$(this);
            }
        });
        return var2_2;
    }

    public final boolean maxRestartsReached() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", (Object)this.settings.maxRestartsWithin());
            this.restartCount_$eq(0);
        }
        return this.restartCount() == this.settings.maxRestarts();
    }

    public final void scheduleRestartTimer() {
        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.restartCount(), this.settings.minBackoff(), this.settings.maxBackoff(), this.settings.randomFactor());
        this.log().debug("Restarting graph in {}", (Object)restartDelay);
        this.scheduleOnce((Object)"RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.settings.maxRestartsWithin().fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public RestartWithBackoffLogic(String name, S shape, Attributes inheritedAttributes, RestartSettings settings, boolean onlyOnFailures) {
        this.name = name;
        this.inheritedAttributes = inheritedAttributes;
        this.settings = settings;
        this.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures = onlyOnFailures;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = settings.maxRestartsWithin().fromNow();
        this.finishing = false;
    }
}

