/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.io.ConfigurationResource;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.Clock;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.AbstractResourceLicenseService;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLicenseServiceImpl
extends AbstractResourceLicenseService {
    private static final Logger log = LoggerFactory.getLogger(ResourceLicenseServiceImpl.class);
    private final LicenseReader licenseReader = new LicenseReader();

    public ResourceLicenseServiceImpl(ConfigurationResource licenseResource, String product, RepositoryMetadataService repositoryMetadataService) throws IOException, LicenseParseException, LicenseViolationException {
        super(licenseResource, product, repositoryMetadataService);
        if (!licenseResource.exists()) {
            this.logLicenseError(licenseResource);
            throw new FileNotFoundException("License cannot be found at " + licenseResource.getPath());
        }
        this.license = this.readLicense(licenseResource);
        if (this.license.isDateExpired()) {
            this.logLicenseError(licenseResource);
        }
        if (!this.isAllowedLicenseType(this.license)) {
            this.logLicenseVersionError(this.license);
        }
        if (!this.isValidEdition(this.license)) {
            this.logLicenseEditionError(this.license);
        }
    }

    ResourceLicenseServiceImpl(ConfigurationResource licenseResource, String product, RepositoryMetadataService repositoryMetadataService, Clock clock) throws IOException, LicenseParseException, LicenseViolationException {
        super(licenseResource, product, repositoryMetadataService, clock);
        if (!licenseResource.exists()) {
            this.logLicenseError(licenseResource);
            throw new FileNotFoundException("License cannot be found at " + licenseResource.getPath());
        }
        this.license = this.readLicense(licenseResource);
        if (this.license.isDateExpired()) {
            this.logLicenseError(licenseResource);
        }
        if (!this.isAllowedLicenseType(this.license)) {
            this.logLicenseVersionError(this.license);
        }
        if (!this.isValidEdition(this.license)) {
            this.logLicenseEditionError(this.license);
        }
    }

    @Override
    protected License readLicense(ConfigurationResource licenseResource) throws LicenseParseException, LicenseViolationException {
        try {
            log.info("Reading license from file {}", (Object)licenseResource.getPath());
            License license = this.licenseReader.readLicense(licenseResource);
            log.info(license.toLicenseContent());
            if (license.isDateExpired()) {
                log.warn("*** License has expired.");
            }
            return license;
        }
        catch (IOException e) {
            throw new LicenseParseException(e.getMessage(), (Throwable)e);
        }
    }
}

