/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.winrm;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.ConnectionValidator;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.overthere.winrm.WinRmClient;
import com.xebialabs.overthere.winrm.WinRmRuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmConnection
implements ProcessConnection {
    private int connectionTimeoutMillis;
    private int socketTimeoutMillis;
    private OperatingSystemFamily os;
    private OverthereFile workingDirectory;
    private AddressPortMapper mapper;
    private String address;
    private int port;
    private String password;
    private String username;
    private String protocol;
    private CifsConnectionType connectionType = CifsConnectionType.WINRM_INTERNAL;
    private ConnectionOptions options;
    private final String unmappedAddress;
    private final int unmappedPort;
    public static final int STDIN_BUF_SIZE = 4096;
    private static Logger logger = LoggerFactory.getLogger(WinRmConnection.class);

    public WinRmConnection(ConnectionOptions options, AddressPortMapper mapper, OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.options = options;
        this.mapper = mapper;
        this.os = options.getEnum("os", OperatingSystemFamily.class);
        this.connectionTimeoutMillis = options.getInteger("connectionTimeoutMillis", 120000);
        this.socketTimeoutMillis = options.getInteger("socketTimeoutMillis", 0);
        this.unmappedAddress = (String)options.get("address");
        this.unmappedPort = options.get("port", this.connectionType.getDefaultPort(options));
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(this.unmappedAddress, this.unmappedPort));
        this.address = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.get(ConnectionOptions.PASSWORD);
        this.protocol = (String)options.get("protocol");
        ConnectionValidator.checkIsWindowsHost(this.os, this.protocol, this.connectionType);
        ConnectionValidator.checkNotOldStyleWindowsDomain(this.username, this.protocol, this.connectionType);
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        OverthereUtils.checkNotNull(cmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(cmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        final String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        String cmdString = cmd.toCommandLine(this.os, false);
        if (this.workingDirectory != null) {
            cmdString = "CD /D " + this.workingDirectory.getPath() + " & " + cmdString;
        }
        final WinRmClient winRmClient = this.createWinrmClient();
        try {
            final PipedInputStream fromCallersStdin = new PipedInputStream();
            final PipedOutputStream callersStdin = new PipedOutputStream(fromCallersStdin);
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final PipedInputStream callersStderr = new PipedInputStream();
            final PipedOutputStream toCallersStderr = new PipedOutputStream(callersStderr);
            winRmClient.createShell();
            String commandId = winRmClient.executeCommand(cmdString);
            final Exception[] inputReaderTheaException = new Exception[1];
            Thread inputReaderThead = new Thread(String.format("WinRM input reader for command [%s]", commandId)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = fromCallersStdin.read(buf)) != -1) {
                            if (n == 0) continue;
                            byte[] bufToSend = new byte[n];
                            System.arraycopy(buf, 0, bufToSend, 0, n);
                            winRmClient.sendInput(bufToSend);
                        }
                    }
                    catch (Exception exc) {
                        inputReaderTheaException[0] = exc;
                    }
                    finally {
                        OverthereUtils.closeQuietly(fromCallersStdin);
                    }
                }
            };
            inputReaderThead.setDaemon(true);
            inputReaderThead.start();
            final Exception[] outputReaderThreadException = new Exception[1];
            final Thread outputReaderThread = new Thread(String.format("WinRM output reader for command [%s]", commandId)){

                @Override
                public void run() {
                    try {
                        while (winRmClient.receiveOutput(toCallersStdout, toCallersStderr)) {
                        }
                    }
                    catch (Exception exc) {
                        outputReaderThreadException[0] = exc;
                    }
                    finally {
                        OverthereUtils.closeQuietly(toCallersStdout);
                        OverthereUtils.closeQuietly(toCallersStderr);
                    }
                }
            };
            outputReaderThread.setDaemon(true);
            outputReaderThread.start();
            return new OverthereProcess(){
                boolean processTerminated = false;

                @Override
                public synchronized OutputStream getStdin() {
                    return callersStdin;
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return callersStderr;
                }

                @Override
                public synchronized int waitFor() {
                    if (this.processTerminated) {
                        return this.exitValue();
                    }
                    try {
                        try {
                            outputReaderThread.join();
                        }
                        finally {
                            OverthereUtils.closeQuietly(callersStdin);
                            this.processTerminated = true;
                            try {
                                winRmClient.deleteShell();
                            }
                            catch (Throwable t) {
                                logger.warn("Failure while deleting winrm shell", t);
                            }
                        }
                        if (outputReaderThreadException[0] != null) {
                            if (outputReaderThreadException[0] instanceof RuntimeException) {
                                throw (RuntimeException)outputReaderThreadException[0];
                            }
                            throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCmd, WinRmConnection.this), outputReaderThreadException[0]);
                        }
                        return this.exitValue();
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCmd, WinRmConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (this.processTerminated) {
                        return;
                    }
                    OverthereUtils.closeQuietly(callersStdin);
                    this.processTerminated = true;
                    winRmClient.signal();
                    winRmClient.deleteShell();
                }

                @Override
                public synchronized int exitValue() {
                    if (!this.processTerminated) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on [%s] is still running", obfuscatedCmd, WinRmConnection.this));
                    }
                    return winRmClient.exitValue();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " on " + this, exc);
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private WinRmClient createWinrmClient() {
        WinRmClient client = new WinRmClient(this.username, this.password, this.createWinrmURL(), this.unmappedAddress, this.unmappedPort, this.mapper.socketFactory());
        client.setWinRmTimeout(this.options.get("winrmTimeout", "PT60.000S"));
        client.setWinRmEnvelopSize(this.options.get("winrmEnvelopSize", 153600));
        client.setWinRmLocale(this.options.get("", "en-US"));
        client.setHttpsCertTrustStrategy(this.options.getEnum("winrmHttpsCertificateTrustStrategy", WinrmHttpsCertificateTrustStrategy.class, CifsConnectionBuilder.WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY_DEFAULT));
        client.setHttpsHostnameVerifyStrategy(this.options.getEnum("winrmHttpsHostnameVerificationStrategy", WinrmHttpsHostnameVerificationStrategy.class, CifsConnectionBuilder.WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY_DEFAULT));
        client.setKerberosUseHttpSpn(this.options.getBoolean("winrmKerberosUseHttpSpn", false));
        client.setKerberosAddPortToSpn(this.options.getBoolean("winrmKerberosAddPortToSpn", false));
        client.setKerberosDebug(this.options.getBoolean("winrmKerberosDebug", false));
        client.setKerberosTicketCache(this.options.getBoolean("winrmKerberosTicketCache", false));
        client.setConnectionTimeout(this.connectionTimeoutMillis);
        client.setSoTimeout(this.socketTimeoutMillis);
        client.setUseCanonicalHostname(this.options.getBoolean("winrmUseCanonicalHostname", false));
        return client;
    }

    private URL createWinrmURL() {
        String scheme = this.options.getBoolean("winrmEnableHttps", false) ? "https" : "http";
        String context = this.options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRmRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }
}

