/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Optional;
import java.util.function.ToLongFunction;

class JvmMemory {
    private JvmMemory() {
    }

    static Optional<MemoryPoolMXBean> getLongLivedHeapPool() {
        return ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class).stream().filter(JvmMemory::isHeap).filter(mem -> JvmMemory.isOldGenPool(mem.getName()) || JvmMemory.isNonGenerationalHeapPool(mem.getName())).findAny();
    }

    static boolean isConcurrentPhase(String cause, String name) {
        return "No GC".equals(cause) || "Shenandoah Cycles".equals(name);
    }

    static boolean isAllocationPool(String name) {
        return name != null && name.endsWith("Eden Space");
    }

    static boolean isOldGenPool(String name) {
        return name != null && (name.endsWith("Old Gen") || name.endsWith("Tenured Gen"));
    }

    static boolean isNonGenerationalHeapPool(String name) {
        return "Shenandoah".equals(name) || "ZHeap".equals(name);
    }

    private static boolean isHeap(MemoryPoolMXBean memoryPoolBean) {
        return MemoryType.HEAP.equals((Object)memoryPoolBean.getType());
    }

    static double getUsageValue(MemoryPoolMXBean memoryPoolMXBean, ToLongFunction<MemoryUsage> getter) {
        MemoryUsage usage = JvmMemory.getUsage(memoryPoolMXBean);
        if (usage == null) {
            return Double.NaN;
        }
        return getter.applyAsLong(usage);
    }

    @Nullable
    private static MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError e) {
            return null;
        }
    }
}

