/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.SimpleDnsCache;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import akka.util.Timeout;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rUa!\u0002\u001e<\u0005}\u001a\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011e\u0003!\u0011!Q\u0001\niC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006{\u0002!\tA \u0005\n\u0003\u0013\u0001!\u0019!C\u0002\u0003\u0017A\u0001\"!\u0007\u0001A\u0003%\u0011Q\u0002\u0005\n\u00037\u0001!\u0019!C\u0002\u0003;A\u0001\"a\u000b\u0001A\u0003%\u0011q\u0004\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003_Aq!!\r\u0001A\u0003%Q\rC\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026!A\u0011\u0011\u000b\u0001!\u0002\u0013\t9\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0001\u00026!A\u0011Q\u000b\u0001!\u0002\u0013\t9\u0004C\u0005\u0002X\u0001\u0001\r\u0011\"\u0003\u0002Z!I\u0011\u0011\r\u0001A\u0002\u0013%\u00111\r\u0005\t\u0003_\u0002\u0001\u0015)\u0003\u0002\\!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004\"CA;\u0001\t\u0007I\u0011BA<\u0011\u001d\tI\b\u0001Q\u0001\neDq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBAy\u0001\u0011%\u00111\u001f\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u000f!\u00119b\u000fE\u0001\u007f\teaa\u0002\u001e<\u0011\u0003y$1\u0004\u0005\u0007{r!\tA!\b\t\u0013\t}AD1A\u0005\n\t\u0005\u0002\u0002\u0003B\u00199\u0001\u0006IAa\t\t\u0013\tMBD1A\u0005\n\t\u0005\u0002\u0002\u0003B\u001b9\u0001\u0006IAa\t\t\u000f\t]B\u0004\"\u0003\u0003:!I!1\t\u000fC\u0002\u0013%!Q\t\u0005\t\u0005\u000fb\u0002\u0015!\u0003\u0002F\u001a1!\u0011\n\u000fA\u0005\u0017B!Ba\u0018&\u0005+\u0007I\u0011\u0001B1\u0011)\u0011\u0019'\nB\tB\u0003%\u00111\u0015\u0005\u0007{\u0016\"\tA!\u001a\t\u0013\t5T%!A\u0005\u0002\t=\u0004\"\u0003B:KE\u0005I\u0011\u0001B;\u0011%\u0011I)JA\u0001\n\u0003\u0012Y\tC\u0005\u0003\u0018\u0016\n\t\u0011\"\u0001\u0003\u001a\"I!\u0011U\u0013\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005[+\u0013\u0011!C!\u0005_C\u0011B!0&\u0003\u0003%\tAa0\t\u0013\t\rW%!A\u0005B\t\u0015\u0007\"\u0003BeK\u0005\u0005I\u0011\tBf\u0011%\u0011i-JA\u0001\n\u0003\u0012ymB\u0005\u0003Tr\t\t\u0011#\u0001\u0003V\u001aI!\u0011\n\u000f\u0002\u0002#\u0005!q\u001b\u0005\u0007{R\"\tA!<\t\u0013\t=H'!A\u0005F\tE\b\"\u0003Bzi\u0005\u0005I\u0011\u0011B{\u0011%\u0011I\u0010NA\u0001\n\u0003\u0013Y\u0010C\u0005\u0004\bQ\n\t\u0011\"\u0003\u0004\n\t\u0001\u0012i]=oG\u0012s7OU3t_24XM\u001d\u0006\u0003yu\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003}}\n1\u0001\u001a8t\u0015\t\u0001\u0015)\u0001\u0002j_*\t!)\u0001\u0003bW.\f7\u0003\u0002\u0001E\u0015B\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007CA&O\u001b\u0005a%BA'B\u0003\u0015\t7\r^8s\u0013\tyEJA\u0003BGR|'\u000f\u0005\u0002L#&\u0011!\u000b\u0014\u0002\r\u0003\u000e$xN\u001d'pO\u001eLgnZ\u0001\tg\u0016$H/\u001b8hg\u000e\u0001\u0001C\u0001,X\u001b\u0005i\u0014B\u0001->\u0005-!en]*fiRLgnZ:\u0002\u000b\r\f7\r[3\u0011\u0005mcV\"A \n\u0005u{$AD*j[BdW\r\u00128t\u0007\u0006\u001c\u0007.Z\u0001\u000eG2LWM\u001c;GC\u000e$xN]=\u0011\u000b\u0015\u0003'-Z=\n\u0005\u00054%!\u0003$v]\u000e$\u0018n\u001c83!\tY5-\u0003\u0002e\u0019\ny\u0011i\u0019;peJ+gMR1di>\u0014\u0018\u0010E\u0002g]Ft!a\u001a7\u000f\u0005!\\W\"A5\u000b\u0005)$\u0016A\u0002\u001fs_>$h(C\u0001H\u0013\tig)A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0004(\u0001\u0002'jgRT!!\u001c$\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018a\u00018fi*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\t\u0004M:T\bCA&|\u0013\taHJ\u0001\u0005BGR|'OU3g\u0003\u0019a\u0014N\\5u}Q9q0a\u0001\u0002\u0006\u0005\u001d\u0001cAA\u0001\u00015\t1\bC\u0003T\t\u0001\u0007Q\u000bC\u0003Z\t\u0001\u0007!\fC\u0003_\t\u0001\u0007q,\u0001\u0002fGV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003$\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0018\u0005E!\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006\u0019Qm\u0019\u0011\u0002\u000fQLW.Z8viV\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011QE!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\t\u0019CA\u0004US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\n1B\\1nKN+'O^3sgV\tQ-\u0001\u0007oC6,7+\u001a:wKJ\u001c\b%A\nq_NLG/\u001b<f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u00170\u0006\u0002\u00028A!\u0011\u0011HA&\u001d\u0011\tY$a\u0012\u000f\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\u0019ED\u0002i\u0003\u0003J\u0011AQ\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005%S(A\u0006DC\u000eDW\rU8mS\u000eL\u0018\u0002BA'\u0003\u001f\u00121bQ1dQ\u0016\u0004v\u000e\\5ds*\u0019\u0011\u0011J\u001f\u0002)A|7/\u001b;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=!\u0003MqWmZ1uSZ,7)Y2iKB{G.[2z\u0003QqWmZ1uSZ,7)Y2iKB{G.[2zA\u0005I!/Z9vKN$\u0018\nZ\u000b\u0003\u00037\u00022!RA/\u0013\r\tyF\u0012\u0002\u0006'\"|'\u000f^\u0001\u000ee\u0016\fX/Z:u\u0013\u0012|F%Z9\u0015\t\u0005\u0015\u00141\u000e\t\u0004\u000b\u0006\u001d\u0014bAA5\r\n!QK\\5u\u0011%\ti\u0007EA\u0001\u0002\u0004\tY&A\u0002yIE\n!B]3rk\u0016\u001cH/\u00133!\u0003\u0019qW\r\u001f;JIR\u0011\u00111L\u0001\ne\u0016\u001cx\u000e\u001c<feN,\u0012!_\u0001\u000be\u0016\u001cx\u000e\u001c<feN\u0004\u0013a\u0002:fG\u0016Lg/Z\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u00046\t\u0001!C\u0002\u0002\u0006:\u0013qAU3dK&4X-\u0001\u000bsKN|GN^3XSRD'+Z:pYZ,'o\u001d\u000b\t\u0003\u0017\u000by*a-\u0002@B1\u0011qBAG\u0003#KA!a$\u0002\u0012\t1a)\u001e;ve\u0016\u0004B!a%\u0002\u001a:\u0019a+!&\n\u0007\u0005]U(A\u0006E]N\u0004&o\u001c;pG>d\u0017\u0002BAN\u0003;\u0013\u0001BU3t_24X\r\u001a\u0006\u0004\u0003/k\u0004bBAQ-\u0001\u0007\u00111U\u0001\u0005]\u0006lW\r\u0005\u0003\u0002&\u00065f\u0002BAT\u0003S\u0003\"\u0001\u001b$\n\u0007\u0005-f)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\u000b\tL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003W3\u0005bBA[-\u0001\u0007\u0011qW\u0001\fe\u0016\fX/Z:u)f\u0004X\r\u0005\u0003\u0002:\u0006mf\u0002BA\u001e\u0003+KA!!0\u0002\u001e\nY!+Z9vKN$H+\u001f9f\u0011\u0019\t)H\u0006a\u0001s\u0006a1/\u001a8e#V,7\u000f^5p]R1\u0011QYAm\u0003;\u0004b!a\u0004\u0002\u000e\u0006\u001d\u0007\u0003BAe\u0003'tA!a3\u0002P:!\u00111HAg\u0013\taT(C\u0002\u0002Rn\n\u0011\u0002\u00128t\u00072LWM\u001c;\n\t\u0005U\u0017q\u001b\u0002\u0007\u0003:\u001cx/\u001a:\u000b\u0007\u0005E7\b\u0003\u0004\u0002\\^\u0001\rA_\u0001\te\u0016\u001cx\u000e\u001c<fe\"9\u0011q\\\fA\u0002\u0005\u0005\u0018aB7fgN\fw-\u001a\t\u0005\u0003\u0013\f\u0019/\u0003\u0003\u0002f\u0006]'a\u0003#ogF+Xm\u001d;j_:\f\u0011C]3t_24XmV5uQN+\u0017M]2i)!\tY)a;\u0002n\u0006=\bbBAQ1\u0001\u0007\u00111\u0015\u0005\b\u0003kC\u0002\u0019AA\\\u0011\u0019\tY\u000e\u0007a\u0001u\u0006a!/Z:pYZ,g)\u001b:tiRA\u00111RA{\u0003w\fi\u0010C\u0004\u0002xf\u0001\r!!?\u0002\u0017M,\u0017M]2i\u001d\u0006lWm\u001d\t\u0005M:\f\u0019\u000bC\u0004\u00026f\u0001\r!a.\t\r\u0005m\u0017\u00041\u0001{\u0003\u001d\u0011Xm]8mm\u0016$\u0002\"a#\u0003\u0004\t\u0015!q\u0001\u0005\b\u0003CS\u0002\u0019AAR\u0011\u001d\t)L\u0007a\u0001\u0003oCa!a7\u001b\u0001\u0004Q\bf\u0001\u0001\u0003\fA!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u0011\u0003NLhn\u0019#ogJ+7o\u001c7wKJ\u00042!!\u0001\u001d'\taB\t\u0006\u0002\u0003\u001a\u0005Y\u0011\u000e\u001d<5\u0003\u0012$'/Z:t+\t\u0011\u0019\u0003\u0005\u0003\u0003&\t5RB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\u00115\fGo\u00195j]\u001eT1!!\nG\u0013\u0011\u0011yCa\n\u0003\u000bI+w-\u001a=\u0002\u0019%\u0004h\u000fN!eIJ,7o\u001d\u0011\u0002\u0017%\u0004hON!eIJ,7o]\u0001\rSB4h'\u00113ee\u0016\u001c8\u000fI\u0001\u000eSNLe.\u001a;BI\u0012\u0014Xm]:\u0015\t\tm\"\u0011\t\t\u0004\u000b\nu\u0012b\u0001B \r\n9!i\\8mK\u0006t\u0007bBAQE\u0001\u0007\u00111U\u0001\u0006\u000b6\u0004H/_\u000b\u0003\u0003\u000b\fa!R7qif\u0004#A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0014\u000f\u0015\u0012iEa\u0015\u0003ZA\u0019aMa\u0014\n\u0007\tE\u0003OA\u0005Fq\u000e,\u0007\u000f^5p]B\u0019QI!\u0016\n\u0007\t]cIA\u0004Qe>$Wo\u0019;\u0011\u0007\u0019\u0014Y&C\u0002\u0003^A\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f1!\\:h+\t\t\u0019+\u0001\u0003ng\u001e\u0004C\u0003\u0002B4\u0005W\u00022A!\u001b&\u001b\u0005a\u0002b\u0002B0Q\u0001\u0007\u00111U\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003h\tE\u0004\"\u0003B0SA\u0005\t\u0019AAR\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001e+\t\u0005\r&\u0011P\u0016\u0003\u0005w\u0002BA! \u0003\u00066\u0011!q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0003$\n\t\t\u001d%q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u000eB!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014V\fA\u0001\\1oO&!\u0011q\u0016BI\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011Y\nE\u0002F\u0005;K1Aa(G\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Ka+\u0011\u0007\u0015\u00139+C\u0002\u0003*\u001a\u00131!\u00118z\u0011%\ti'LA\u0001\u0002\u0004\u0011Y*A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\f\u0005\u0004\u00034\ne&QU\u0007\u0003\u0005kS1Aa.G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005w\u0013)L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001e\u0005\u0003D\u0011\"!\u001c0\u0003\u0003\u0005\rA!*\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u001b\u00139\rC\u0005\u0002nA\n\t\u00111\u0001\u0003\u001c\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u001c\u00061Q-];bYN$BAa\u000f\u0003R\"I\u0011Q\u000e\u001a\u0002\u0002\u0003\u0007!QU\u0001\u0017%\u0016\u001cx\u000e\u001c<f\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]B\u0019!\u0011\u000e\u001b\u0014\u000bQ\u0012IN!:\u0011\u0011\tm'\u0011]AR\u0005Oj!A!8\u000b\u0007\t}g)A\u0004sk:$\u0018.\\3\n\t\t\r(Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002Bt\u0005Wl!A!;\u000b\u0005\u0001+\u0018\u0002\u0002B/\u0005S$\"A!6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!$\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t\u001d$q\u001f\u0005\b\u0005?:\u0004\u0019AAR\u0003\u001d)h.\u00199qYf$BA!@\u0004\u0004A)QIa@\u0002$&\u00191\u0011\u0001$\u0003\r=\u0003H/[8o\u0011%\u0019)\u0001OA\u0001\u0002\u0004\u00119'A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u0003\u0011\t\t=5QB\u0005\u0005\u0007\u001f\u0011\tJ\u0001\u0004PE*,7\r\u001e\u0015\u00049\t-\u0001fA\u000e\u0003\f\u0001")
@InternalApi
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final SimpleDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)(mode = resolve.requestType())));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        this.$outer.sender().$bang(resolved2, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1 & Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((IterableOnceOps)((SeqOps)resolved.records().map((Function1 & Serializable)x$1 -> x$1.ttl())).$plus$colon((Object)cachePolicy)).min((Ordering)package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String akka.io.dns.DnsProtocol$RequestType akka.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected address: ").append(inetAddress).toString());
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)package$.MODULE$.Nil().$colon$colon((Object)aRecord));
            }));
        } else {
            Future future2;
            List<ActorRef> list = resolvers;
            Nil$ nil$ = package$.MODULE$.Nil();
            List<ActorRef> list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                future2 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ActorRef head = (ActorRef)colon2.head();
                List tail = colon2.next$access$1();
                future2 = this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new Serializable(this, name, requestType, tail){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$2;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Future<DnsProtocol.Resolved> future;
                        Option option;
                        A1 A1 = x1;
                        if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                            Throwable t = (Throwable)option.get();
                            Throwable throwable = t;
                            if (throwable instanceof AskTimeoutException) {
                                this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$2, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.timeout().duration())));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$2, t.getMessage());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply(x1);
                        }
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Option option;
                        Throwable throwable = x1;
                        boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$2 = name$2;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.failed().foreach((Function1 & Serializable)x$2 -> {
            resolver.$bang(new DnsClient.DropRequest(message.id()), this.self());
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        if (this.settings.SearchDomains().nonEmpty()) {
            List list;
            List nameWithSearch = this.settings.SearchDomains().map((Function1 & Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString());
            if (StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar((Object)x$3)))) >= this.settings.NDots()) {
                String string = name;
                list = nameWithSearch.$colon$colon((Object)string);
            } else {
                list = (List)nameWithSearch.$colon$plus((Object)name);
            }
            List toResolve = list;
            future = this.resolveFirst((List<String>)toResolve, requestType, resolver);
        } else {
            future = this.resolve(name, requestType, resolver);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<String> list = searchNames;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String searchName = (String)colon2.head();
            List list2 = colon2.next$access$1();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (nil$ == null) {
                if (list3 == null) return this.resolve(searchName, requestType, resolver);
            } else if (nil$.equals(list3)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)colon2.head();
            List remaining = colon2.next$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1 & Serializable)resolved -> resolved.records().isEmpty() ? this.resolveFirst((List<String>)remaining, requestType, resolver) : Future$.MODULE$.successful(resolved), (ExecutionContext)this.ec());
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list4 = list;
        if (nil$ != null) {
            if (!nil$.equals(list4)) throw new MatchError(list);
            return Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        }
        if (list4 == null) return Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        throw new MatchError(list);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            future = ipv4Recs.flatMap((Function1 & Serializable)ipv4 -> ipv6Recs.map((Function1 & Serializable)ipv6 -> new DnsProtocol.Resolved(name, (Seq<ResourceRecord>)((Seq)ipv4.rrs().$plus$plus(ipv6.rrs())), (Seq<ResourceRecord>)((Seq)ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs()))), (ExecutionContext)this.ec()), (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            future = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1 & Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), (ExecutionContext)this.ec());
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$3) {
        return x$3 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
        Statics.releaseFence();
    }

    public static class ResolveFailedException
    extends Exception
    implements Product {
        private final String msg;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.msg();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "msg";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

