/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;

class CommittableIndexReader
extends FilterIndexReader {
    private volatile long modCount;

    CommittableIndexReader(IndexReader in) {
        super(in);
        this.modCount = in.getVersion();
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        super.doDelete(n);
        ++this.modCount;
    }

    long getModificationCount() {
        return this.modCount;
    }
}

