/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.bridge;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.mcast.MulticastEndpoint;

public class MulticastAccessPoint {
    private static List<Channel> remoteChannels = Collections.synchronizedList(new ArrayList());
    private static MulticastEndpoint mcast = new MulticastEndpoint();

    public static void main(String[] args) {
        int port = Integer.parseInt(args[0]);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() {
                return ChannelPipelineFactory.handlerList(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (mcast != null && mcast.isInit()) {
                            mcast.send((ByteBuf)msg);
                        }
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        remoteChannels.add(ctx.channel());
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        remoteChannels.add(ctx.channel());
                    }

                    public void exceptionCaught(ChannelHandlerContext paramChannelHandlerContext, Throwable e) throws Exception {
                        Throwable cause = e.getCause();
                        System.out.println(e);
                    }
                }});
            }
        });
        try {
            bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            mcast.init(new ChannelPipelineFactory(){

                @Override
                public ChannelPipelineFactory.HandlerList getPipeline() {
                    return ChannelPipelineFactory.handlerList(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            ByteBuf b = mcast.getMessage((ByteBuf)msg);
                            if (b == null) {
                                return;
                            }
                            for (Channel c : remoteChannels) {
                                if (!c.isActive()) continue;
                                c.write((Object)b);
                            }
                        }
                    }});
                }
            });
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
    }
}

