/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import com.zaxxer.hikari.HikariConfigMXBean;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class DataSourcePoolMetricsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HikariDataSource.class})
    static class HikariDataSourceMetricsConfiguration {
        private static final Log logger = LogFactory.getLog(HikariDataSourceMetricsConfiguration.class);
        private final MeterRegistry registry;

        HikariDataSourceMetricsConfiguration(MeterRegistry registry) {
            this.registry = registry;
        }

        @Autowired
        void bindMetricsRegistryToHikariDataSources(Collection<DataSource> dataSources) {
            for (DataSource dataSource : dataSources) {
                HikariDataSource hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, HikariConfigMXBean.class, HikariDataSource.class);
                if (hikariDataSource == null) continue;
                this.bindMetricsRegistryToHikariDataSource(hikariDataSource);
            }
        }

        private void bindMetricsRegistryToHikariDataSource(HikariDataSource hikari) {
            if (hikari.getMetricRegistry() == null && hikari.getMetricsTrackerFactory() == null) {
                try {
                    hikari.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(this.registry));
                }
                catch (Exception ex) {
                    logger.warn((Object)LogMessage.format((String)"Failed to bind Hikari metrics: %s", (Object)ex.getMessage()));
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={DataSourcePoolMetadataProvider.class})
    static class DataSourcePoolMetadataMetricsConfiguration {
        private static final String DATASOURCE_SUFFIX = "dataSource";

        DataSourcePoolMetadataMetricsConfiguration() {
        }

        @Autowired
        void bindDataSourcesToRegistry(Map<String, DataSource> dataSources, MeterRegistry registry, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
            List metadataProvidersList = metadataProviders.stream().collect(Collectors.toList());
            dataSources.forEach((name, dataSource) -> this.bindDataSourceToRegistry((String)name, (DataSource)dataSource, metadataProvidersList, registry));
        }

        private void bindDataSourceToRegistry(String beanName, DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, MeterRegistry registry) {
            String dataSourceName = this.getDataSourceName(beanName);
            new DataSourcePoolMetrics(dataSource, metadataProviders, dataSourceName, Collections.emptyList()).bindTo(registry);
        }

        private String getDataSourceName(String beanName) {
            if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
                return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
            }
            return beanName;
        }
    }
}

