/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.AbstractEndpointCondition;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnAvailableEndpointCondition
extends AbstractEndpointCondition {
    private static final String JMX_ENABLED_KEY = "spring.jmx.enabled";
    private static final Map<Environment, Set<Exposure>> exposuresCache = new ConcurrentReferenceHashMap();

    OnAvailableEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionOutcome enablementOutcome = this.getEnablementOutcome(context, metadata, ConditionalOnAvailableEndpoint.class);
        if (!enablementOutcome.isMatch()) {
            return enablementOutcome;
        }
        ConditionMessage message = enablementOutcome.getConditionMessage();
        Environment environment = context.getEnvironment();
        if (CloudPlatform.CLOUD_FOUNDRY.isActive(environment)) {
            return new ConditionOutcome(true, message.andCondition(ConditionalOnAvailableEndpoint.class, new Object[0]).because("application is running on Cloud Foundry"));
        }
        EndpointId id = EndpointId.of((Environment)environment, (String)this.getEndpointAttributes(ConditionalOnAvailableEndpoint.class, context, metadata).getString("id"));
        Set<Exposure> exposures = this.getExposures(environment);
        for (Exposure exposure : exposures) {
            if (!exposure.isExposed(id)) continue;
            return new ConditionOutcome(true, message.andCondition(ConditionalOnAvailableEndpoint.class, new Object[0]).because("marked as exposed by a 'management.endpoints." + exposure.getPrefix() + ".exposure' property"));
        }
        return new ConditionOutcome(false, message.andCondition(ConditionalOnAvailableEndpoint.class, new Object[0]).because("no 'management.endpoints' property marked it as exposed"));
    }

    private Set<Exposure> getExposures(Environment environment) {
        Set<Exposure> exposures = exposuresCache.get(environment);
        if (exposures == null) {
            exposures = new HashSet<Exposure>(2);
            if (((Boolean)environment.getProperty(JMX_ENABLED_KEY, Boolean.class, (Object)false)).booleanValue()) {
                exposures.add(new Exposure(environment, "jmx", IncludeExcludeEndpointFilter.DefaultIncludes.JMX));
            }
            exposures.add(new Exposure(environment, "web", IncludeExcludeEndpointFilter.DefaultIncludes.WEB));
            exposuresCache.put(environment, exposures);
        }
        return exposures;
    }

    static class Exposure
    extends IncludeExcludeEndpointFilter<ExposableEndpoint<?>> {
        private final String prefix;

        Exposure(Environment environment, String prefix, IncludeExcludeEndpointFilter.DefaultIncludes defaultIncludes) {
            super(ExposableEndpoint.class, environment, "management.endpoints." + prefix + ".exposure", defaultIncludes);
            this.prefix = prefix;
        }

        String getPrefix() {
            return this.prefix;
        }

        boolean isExposed(EndpointId id) {
            return super.match(id);
        }
    }
}

