/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final ConcurrentMap<FileSystem, ConcurrentMap<FileName, FileObject>> filesystemCache = new ConcurrentHashMap<FileSystem, ConcurrentMap<FileName, FileObject>>(10);

    @Override
    public void putFile(FileObject file) {
        ConcurrentMap<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        files.put(file.getName(), file);
    }

    @Override
    public boolean putFileIfAbsent(FileObject file) {
        ConcurrentMap<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        return files.putIfAbsent(file.getName(), file) == null;
    }

    @Override
    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files = (Map)this.filesystemCache.get(filesystem);
        if (files == null) {
            return null;
        }
        return (FileObject)files.get(name);
    }

    @Override
    public void clear(FileSystem filesystem) {
        Map files = (Map)this.filesystemCache.remove(filesystem);
        if (files != null) {
            files.clear();
        }
    }

    protected ConcurrentMap<FileName, FileObject> getOrCreateFilesystemCache(FileSystem filesystem) {
        ConcurrentMap files = (ConcurrentMap)this.filesystemCache.get(filesystem);
        while (files == null) {
            this.filesystemCache.putIfAbsent(filesystem, new ConcurrentHashMap(200, 0.75f, 8));
            files = (ConcurrentMap)this.filesystemCache.get(filesystem);
        }
        return files;
    }

    @Override
    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    @Override
    public void removeFile(FileSystem filesystem, FileName name) {
        Map files = (Map)this.filesystemCache.get(filesystem);
        if (files != null) {
            files.remove(name);
        }
    }
}

