/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.OptionsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OptionsMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger((Class)OptionsMethod.class);
    private final Set allowedMethods = new HashSet();
    private final Set complianceClasses = new HashSet();

    public OptionsMethod(String uri) {
        super(uri);
    }

    public OptionsMethod(String uri, String[] optionsEntries) throws IOException {
        this(uri, new OptionsInfo(optionsEntries));
    }

    public OptionsMethod(String uri, OptionsInfo optionsInfo) throws IOException {
        super(uri);
        if (optionsInfo != null) {
            this.setRequestBody(optionsInfo);
        }
    }

    public OptionsResponse getResponseAsOptionsResponse() throws IOException {
        this.checkUsed();
        OptionsResponse or = null;
        Element rBody = this.getRootElement();
        if (rBody != null) {
            or = OptionsResponse.createFromXml(rBody);
        }
        return or;
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.allowedMethods.contains(method.toUpperCase());
    }

    public String[] getAllowedMethods() {
        this.checkUsed();
        return this.allowedMethods.toArray(new String[this.allowedMethods.size()]);
    }

    public boolean hasComplianceClass(String complianceClass) {
        this.checkUsed();
        return this.complianceClasses.contains(complianceClass);
    }

    public String[] getComplianceClasses() {
        this.checkUsed();
        return this.complianceClasses.toArray(new String[this.complianceClasses.size()]);
    }

    public String getName() {
        return "OPTIONS";
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        Header dav;
        Header allow = this.getResponseHeader("Allow");
        if (allow != null) {
            String[] methods = allow.getValue().split(",");
            for (int i = 0; i < methods.length; ++i) {
                this.allowedMethods.add(methods[i].trim().toUpperCase());
            }
        }
        if ((dav = this.getResponseHeader("DAV")) != null) {
            String[] classes = dav.getValue().split(",");
            for (int i = 0; i < classes.length; ++i) {
                this.complianceClasses.add(classes[i].trim());
            }
        }
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

