/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryWebEndpointDiscoverer;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundryReactiveHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundryWebFluxEndpointHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveTokenValidator;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryInfoEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.ReactiveHealthEndpointWebExtension;
import org.springframework.boot.actuate.info.GitInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.actuate.info.InfoPropertiesInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebFilter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="management.cloudfoundry", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={HealthEndpointAutoConfiguration.class, InfoEndpointAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class ReactiveCloudFoundryActuatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnBean(value={HealthEndpoint.class, ReactiveHealthEndpointWebExtension.class})
    public CloudFoundryReactiveHealthEndpointWebExtension cloudFoundryReactiveHealthEndpointWebExtension(ReactiveHealthEndpointWebExtension reactiveHealthEndpointWebExtension) {
        return new CloudFoundryReactiveHealthEndpointWebExtension(reactiveHealthEndpointWebExtension);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnBean(value={InfoEndpoint.class, GitProperties.class})
    public CloudFoundryInfoEndpointWebExtension cloudFoundryInfoEndpointWebExtension(GitProperties properties, ObjectProvider<InfoContributor> infoContributors) {
        List contributors = infoContributors.orderedStream().map(infoContributor -> infoContributor instanceof GitInfoContributor ? new GitInfoContributor(properties, InfoPropertiesInfoContributor.Mode.FULL) : infoContributor).collect(Collectors.toList());
        return new CloudFoundryInfoEndpointWebExtension(new InfoEndpoint(contributors));
    }

    @Bean
    public CloudFoundryWebFluxEndpointHandlerMapping cloudFoundryWebFluxEndpointHandlerMapping(ParameterValueMapper parameterMapper, EndpointMediaTypes endpointMediaTypes, WebClient.Builder webClientBuilder, ControllerEndpointsSupplier controllerEndpointsSupplier, ApplicationContext applicationContext) {
        CloudFoundryWebEndpointDiscoverer endpointDiscoverer = new CloudFoundryWebEndpointDiscoverer(applicationContext, parameterMapper, endpointMediaTypes, null, Collections.emptyList(), Collections.emptyList());
        CloudFoundrySecurityInterceptor securityInterceptor = this.getSecurityInterceptor(webClientBuilder, applicationContext.getEnvironment());
        Collection webEndpoints = endpointDiscoverer.getEndpoints();
        ArrayList allEndpoints = new ArrayList();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new CloudFoundryWebFluxEndpointHandlerMapping(new EndpointMapping("/cloudfoundryapplication"), webEndpoints, endpointMediaTypes, this.getCorsConfiguration(), securityInterceptor, new EndpointLinksResolver(allEndpoints));
    }

    private CloudFoundrySecurityInterceptor getSecurityInterceptor(WebClient.Builder webClientBuilder, Environment environment) {
        ReactiveCloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(webClientBuilder, environment);
        ReactiveTokenValidator tokenValidator = new ReactiveTokenValidator(cloudfoundrySecurityService);
        return new CloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment.getProperty("vcap.application.application_id"));
    }

    private ReactiveCloudFoundrySecurityService getCloudFoundrySecurityService(WebClient.Builder webClientBuilder, Environment environment) {
        String cloudControllerUrl = environment.getProperty("vcap.application.cf_api");
        boolean skipSslValidation = (Boolean)environment.getProperty("management.cloudfoundry.skip-ssl-validation", Boolean.class, (Object)false);
        return cloudControllerUrl != null ? new ReactiveCloudFoundrySecurityService(webClientBuilder, cloudControllerUrl, skipSslValidation) : null;
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    private static class WebFilterChainPostProcessor
    implements BeanPostProcessor {
        private WebFilterChainPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebFilterChainProxy) {
                return this.postProcess((WebFilterChainProxy)bean);
            }
            return bean;
        }

        private WebFilterChainProxy postProcess(WebFilterChainProxy existing) {
            ServerWebExchangeMatcher cloudFoundryRequestMatcher = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/cloudfoundryapplication/**"});
            WebFilter noOpFilter = (exchange, chain) -> chain.filter(exchange);
            MatcherSecurityWebFilterChain ignoredRequestFilterChain = new MatcherSecurityWebFilterChain(cloudFoundryRequestMatcher, Collections.singletonList(noOpFilter));
            MatcherSecurityWebFilterChain allRequestsFilterChain = new MatcherSecurityWebFilterChain(ServerWebExchangeMatchers.anyExchange(), Collections.singletonList(existing));
            return new WebFilterChainProxy(new SecurityWebFilterChain[]{ignoredRequestFilterChain, allRequestsFilterChain});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MatcherSecurityWebFilterChain.class})
    static class IgnoredPathsSecurityConfiguration {
        IgnoredPathsSecurityConfiguration() {
        }

        @Bean
        WebFilterChainPostProcessor webFilterChainPostProcessor() {
            return new WebFilterChainPostProcessor();
        }
    }
}

